<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="https://puesc.gov.pl/ZEFIR2/xsd/v1_0/PZOO.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="https://puesc.gov.pl/ZEFIR2/xsd/v11_0/Types.xsd" xmlns:ns4="https://puesc.gov.pl/ZEFIR2/xsd/v11_0/Trader.xsd" xmlns:opal="https://puesc.gov.pl/ZEFIR2/xsd/v1_0/PZOO.xsd" xmlns:tp="https://puesc.gov.pl/ZEFIR2/xsd/v11_0/Types.xsd" xmlns:tr="https://puesc.gov.pl/ZEFIR2/xsd/v11_0/Trader.xsd" xmlns:tr8="https://puesc.gov.pl/ZEFIR2/xsd/v11_0/Trader.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="UTF-8" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:value-of select="name()"/> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_OPAL" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_OPAL"> <xsl:for-each select=" ns1:Header |  ns4:* | opal:Header | tr:* "> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <xsl:apply-templates mode="Seed" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <!--<xsl:apply-templates mode="rok_mc" select="."/> --> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <!--<xsl:apply-templates mode="PodstawaPrawna" select="."/> --> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:apply-templates mode="Adres" select="."/> <!-- SZABLON DOT. KWOTY PODATKU --> <!-- <xsl:apply-templates mode="KwotaPodatku" select="."/> --> <xsl:apply-templates mode="SzczegolyPZOO" select="."/> <xsl:apply-templates mode="AdresWO" select="."/> <!-- SZABLON DOT. WYROBOW --> <xsl:apply-templates mode="Wyroby" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <!-- <xsl:apply-templates mode="Adnotacje" select="."/> --> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <!-- <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> --> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" height="45" valign="top"> <td align="left" height="45" valign="top" width="auto"> <span class="cz10"> <xsl:choose> <xsl:when test="string-length(@identifier)='10'"> <b>1. Identyfikator podatkowy NIP/<s>numer PESEL</s> </b> <sup>(niepotrzebne skreślić)</sup> <b>składającego</b> </xsl:when> <xsl:otherwise> <b>1. <s>Identyfikator podatkowy NIP</s>/numer PESEL </b> <sup>(niepotrzebne skreślić)</sup> <b>składającego</b> </xsl:otherwise> </xsl:choose> <br/> <b> <span class="cz16"> <xsl:value-of select="@identifier"/> </span> </b> </span> </td> <td align="left" bgcolor="#CCCCCC" height="45" valign="top" width="auto"> <b>2. Nr dokumentu</b> <br/> <br/> <span class="cz12"> <b> <xsl:value-of select="@selfRef"/> </b> </span> </td> <!--<td align="left" bgcolor="#CCCCCC" height="45" width="auto" valign="top"> <b>3. Status</b> <br/> </td> --> </tr> </table> </xsl:template>   <!-- SZABLON DOT.  NUMERU seed --> <xsl:template match="*" mode="Seed"> <table border="1" width="955"> <tr align="left" height="45" valign="top"> <td align="left" height="45" valign="top" width="auto"> <span class="cz10"> <b>3. Numer akcyzowy podatnika </b> <br/> <b> <span class="cz16"> <xsl:value-of select="@exciseIdentifier"/> </span> </b> </span> </td> <!-- <td align="left" bgcolor="#CCCCCC" height="45" width="auto" valign="top"> <b>2. Nr dokumentu</b> <br/> <br/> <span class="cz12"> <b> <xsl:value-of select="@selfRef"/> </b> </span> </td> <td align="left" bgcolor="#CCCCCC" height="45" width="auto" valign="top"> <b>3. Status</b> <br/> </td> --> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | opal:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">PZOO</span> </td> </tr> <tr> <!--	<td height="61" width="154"/> --> <td> <div align="center"> <span class="nag1">POWIADOMIENIE O ZWOLNIENIU Z OBOWIĄZKU OZNACZANIA ZNAKAMI AKCYZY</span> </div> </td> <!-- <td width="243"/> --> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* | opal:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="4"> <span class="nag1">A. WŁAŚCIWY ORGAN I CEL SKŁADANIA POWIADOMIENIA</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="46"/> <td colspan="4"> <b>4. Naczelnik urzędu skarbowego</b> <!--	<xsl:choose> <xsl:when test="contains(@taxOfficeName,'Skarbowy')"> <b>6.Naczelnik urzędu skarbowego/<s>celno-skarbowego</s> </b> <sup>(niepotrzebne skreślić)</sup> <b> w:</b> </xsl:when> <xsl:otherwise> <b>6.<s>Naczelnik urzędu skarbowego</s>/celno-skarbowego</b> <sup>(niepotrzebne skreślić)</sup> <b> w:</b> </xsl:otherwise> </xsl:choose> --> <br/> <span class="cz18"> <xsl:value-of select="@taxOfficeName"/> </span> </td> </tr> <tr> <td class="style3"> <b>5. Cel złożenia formularza</b>(zaznaczyć właściwy kwadrat):  <br/> <br/> <p> <xsl:choose> <xsl:when test="//@submissionAim='Deklaracja'"> <span class="cz18"> ☑ </span>1. złożenie informacji <span class="cz18">☐</span>  2. korekta informacji </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> <xsl:choose> <xsl:when test="//@submissionAim='Korekta'"> <span class="cz18"> ☐</span> 1. złożenie informacji <span class="cz18">☑</span>  2. korekta informacji </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </p> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <xsl:if test="ns1:* | opal:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">B. DANE SKŁADAJĄCEGO</span> </td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag2">B.1. DANE IDENTYFIKACYJNE </span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" height="27" valign="top"> <b>6. Rodzaj składającego </b>(zaznaczyć właściwy kwadrat):    </td> </tr> <tr> <xsl:if test=".//ns1:Trader/@typeOfTaxpayer='N'"> <td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/> <span class="cz18"> ☑ </span> </td> <td align="left" valign="top" width="471">2. osoba fizyczna<br/> <span class="cz18"> ☐ </span> </td> </xsl:if> <xsl:if test=".//ns1:Trader/@typeOfTaxpayer='F'"> <td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/> <span class="cz18"> ☐ </span> </td> <td align="left" valign="top" width="471">2. osoba fizyczna<br/> <span class="cz18"> ☑ </span> <br/> </td> </xsl:if> </tr> <tr> <td align="left" colspan="3" valign="top"> <b>7. Nazwa pełna /Nazwisko, pierwsze imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@fullName"/> </span> <!-- <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> --> <span class="cz18"> <xsl:value-of select="//@surname"/> </span> <span class="cz18"> <xsl:value-of select="//@firstName"/> </span> <!-- <span class="cz18"> <xsl:value-of select="//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select="//@PESEL"/> </span> --> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="Adres"> <xsl:if test="ns1:* | opal:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY/ ADRES ZAMIESZKANIA </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td width="269"> <b>8. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2"> <b>9. Województwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2"> <b>10. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>11. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2"> <b>12. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> <td width="144"> <b>13. Nr domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td width="151"> <b>14. Nr lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="4"> <b>15. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td> <b>16. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="AdresWO"> <xsl:if test="ns1:* | opal:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">C.1. ADRES WOLNEGO OBSZARU CELNEGO, składu celnego albo miejsce docelowe dostawy wewnątrzwspólnotowej lub eksportu </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td width="269"> <b>19. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:DetailsNotification/ns1:AddressWarehouse/@country | opal:DetailsNotification/opal:AddressWarehouse/@country"/> <xsl:value-of select="ns1:Statement/ns3:representative/@phone | opal:Statement/opal:representative/@phone  "/> </span> </td> <td colspan="2"> <b>20. Województwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:DetailsNotification/ns1:AddressWarehouse/@provinceName | opal:DetailsNotification/opal:AddressWarehouse/@provinceName"/> </span> </td> <td colspan="2"> <b>21. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:DetailsNotification/ns1:AddressWarehouse/@districtName | opal:DetailsNotification/opal:AddressWarehouse/@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>22. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:DetailsNotification/ns1:AddressWarehouse/@communeName | opal:DetailsNotification/opal:AddressWarehouse/@communeName"/> </span> </td> <td colspan="2"> <b>23. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:DetailsNotification/ns1:AddressWarehouse/@street | opal:DetailsNotification/opal:AddressWarehouse/@street"/> </span> </td> <td width="144"> <b>24. Nr domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:DetailsNotification/ns1:AddressWarehouse/@houseNumber | opal:DetailsNotification/opal:AddressWarehouse/@houseNumber"/> </span> </td> <td width="151"> <b>25. Nr lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:DetailsNotification/ns1:AddressWarehouse/@localNumber | opal:DetailsNotification/opal:AddressWarehouse/@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="4"> <b>26. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:DetailsNotification/ns1:AddressWarehouse/@city | opal:DetailsNotification/opal:AddressWarehouse/@city"/> </span> </td> <td> <b>27. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:DetailsNotification/ns1:AddressWarehouse/@postalCode | opal:DetailsNotification/opal:AddressWarehouse/@postalCode"/> </span> </td> </tr> </table> </xsl:if> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">PZOO</span> <sub style="cz9"/>(1) </td> </tr> </table> </xsl:template> <xsl:template match="ns1:Header | opal:*" mode="SzczegolyPZOO"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="4"> <span class="nag1">C. SZCZEGÓŁY POWIADOMIENIA</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="46"/> <td colspan="4"> <b>17. Planowana data wprowadzenia/wydania</b> <br/> <span class="cz18"> <xsl:value-of select="//@plannedDate"/> </span> </td> </tr> <tr> <td class="style3" colspan="2"> <b>18. Podstawa zwolnienia z obowiązku oznaczania</b> <br/> <p> <xsl:choose> <xsl:when test=".//ns1:DetailsNotification/@basisExemption='ExitToZone'"> <span class="cz18"> ☑ </span> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> <b> Wyprowadzenie do wolnego obszaru celnego</b> <br/> </p> <p> <xsl:choose> <xsl:when test=".//ns1:DetailsNotification/@basisExemption='ExitToWarehouse'"> <span class="cz18"> ☑ </span> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> <b> Wyprowadzenie do składu celnego</b> <br/> </p> <p> <xsl:choose> <xsl:when test=".//ns1:DetailsNotification/@basisExemption='IssueForDelivery'"> <span class="cz18"> ☑ </span> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> <b> Wydanie z magazynu wyrobów gotowych w celu dostawy wewnątrzwspólnotowej </b> <br/> </p> <p> <xsl:choose> <xsl:when test=".//ns1:DetailsNotification/@basisExemption='IssueForExport'"> <span class="cz18"> ☑ </span> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> <b> Wydanie z magazynu wyrobów gotowych w celu eksportu </b> <br/>  </p> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | opal:*" mode="Wyroby"> <!-- TABELKA DLA I --> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"/> <table border="1" width="955"> <!-- NAGLOWEK --> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="9"> <span class="nag1">D. DANE WYROBÓW AKCYZOWYCH</span> </td> </tr> <!-- I-OPIS --> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td> <b>Lp. </b> </td> <!-- <td width="110"> Rodzaj opłaty paliwowej</td> --> <td> <b> <p align="center">Grupa wyrobów akcyzowych</p> </b> </td> <td> <b> <p align="center">Nazwa wyrobów</p> </b> </td> <td> <b> <p align="center">Ośmiocyfrowy kod CN (dla wyrobów węglowych – pozycja CN)</p> </b> </td> <!--<td width="110"> <p align="center">Ilość wyrobów, od jakich podmioty, są zobowiązane zapłacić podatek akcyzowy</p> </td> --> <td> <b> <p align="center">Liczba opakowań jednostkowych</p> </b> </td> <!-- <td > <p align="center">Opłata paliwowa<sup>6)</sup> </p> </td> <td> <p align="center">Numer e-SAD <sup>7)</sup> </p> </td> <td> <p align="center">Numer GRN <sup>8)</sup> </p> </td> --> </tr> <!-- II-WIERSZ - OZNACZENIE --> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td> <div align="center"> <b>a.</b> </div> </td> <td> <div align="center"> <b>b.</b> </div> </td> <td> <div align="center"> <b>c.</b> </div> </td> <td> <div align="center"> <b>d.</b> </div> </td> <td> <div align="center"> <b>e.</b> </div> </td> <!--<td> <div align="center"> <b>f.</b> </div> </td> --> <!--<td> <div align="center"> <b>h.</b> </div> </td> <td> <div align="center"> <b>i.</b> </div> </td> <td> <div align="center"> <b>k.</b> </div> </td> --> </tr> <!-- III - WARTOSCI --> <xsl:for-each select="//ns1:Item | //opal:Item"> <tr align="left" valign="top"> <td> <div align="right" class="cz14" valign="top"> <xsl:value-of select="@id"/> </div> </td> <!-- <td> <div align="left" class="cz18" valign="top"> <xsl:value-of select="@typeOfFuelFee"/> </div> <xsl:if test="@typeOfFuelFee = '768'"> - Opłaty pobrane od producentów paliw silnikowych</xsl:if> <xsl:if test="@typeOfFuelFee = '770'"> - Opłaty pobrane od podmiotu dokonującego sprzedaży detalicznej gazu</xsl:if> <xsl:if test="@typeOfFuelFee = '770a'"> - Opłaty pobrane od producenta gazu</xsl:if> <xsl:if test="@typeOfFuelFee = '788'"> - Opłaty pobierane od podmiotów dokonujących nabycia wewnatrzwspolnotowego paliw</xsl:if> <xsl:if test="@typeOfFuelFee = '789'"> - Opłaty pobierane od podmiotów dokonujących nabycia wewnątrzwspólnotowego gazu</xsl:if> </td> --> <td> <div align="left" class="cz12" valign="top"> <xsl:value-of select="@groupOfGoodsName"/> </div> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@goodsName"/> </div> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@codeCN"/> </div> </td> <td> <div align="right" class="cz14" valign="top"> <xsl:value-of select="@numberOfPackingUnits"/> </div> </td> <!-- <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@numberOfGoods"/> </div> </td> --> <!--<td> <div align="right" class="cz14" valign="top"> <xsl:value-of select="@taxRate"/> </div> </td> --> <!-- <td> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(@amountOfFee),'# ##0')"/> </div> <span align="right" class="cz9" valign="bottom">zł</span> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@eSAD"/> </div> </td> <td> <div align="right" class="cz12" valign="top"> <xsl:value-of select="@nrGRN"/> </div> </td> --> </tr> </xsl:for-each> <!-- PODSUMOWANIE TABELKI --> </table> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:* | opal:* | tp:*"> <table border="1" height="210" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <b> <span class="nag1">E. PODPIS SKŁADAJĄCEGO LUB OSOBY REPREZENTUJĄCEJ SKŁADAJĄCEGO</span> </b> <!--<br/>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.--> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="40"/> <td height="37" width="402"> <b>28. Imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> <td width="491"> <b>29. Nazwisko </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname "/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="2"> <b>30. Podpis składającego lub osoby reprezentującej składającego </b> <span class="cz18"> <br/> </span> </td> </tr> <tr align="left" valign="top"> <td height="39"> <xsl:choose> <xsl:when test="string-length(//@repOIdentifier)= 11"> <b>31. <s>Identyfikator podatkowy NIP</s>/numer PESEL</b> <sup>(niepotrzebne skreślić)</sup> <b> osoby składającej podpis</b> </xsl:when> <xsl:when test="string-length(//@repOIdentifier)= 10"> <b>31. Identyfikator podatkowy NIP/<s>numer PESEL</s> </b> <sup>(niepotrzebne skreślić)</sup> <b> osoby składającej podpis</b> </xsl:when> <xsl:otherwise> <b>31. Identyfikator podatkowy NIP/numer PESEL </b> <sup>(niepotrzebne skreślić)</sup> <b> osoby składającej podpis</b> </xsl:otherwise> </xsl:choose> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repIdentifier"/> </span> </td> <td> <b>32. Data wypełnienia deklaracji</b> (dzień – miesiąc – rok) <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="substring(//@declarationDate,9,2)"/> <xsl:value-of select="substring(//@declarationDate,5,4)"/> <xsl:value-of select="substring(//@declarationDate,1,4)"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="3"> <b>33. Numer telefonu i adres e-mail składającego lub osoby reprezentującej składającego </b> (pozycja nieobowiązkowa) <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:Statement/ns3:representative/@phone | opal:Statement/opal:representative/@phone  "/> </span> <span class="cz18"> <xsl:value-of select="ns1:Statement/ns3:representative/@email"/> </span> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">PZOO</span> <sub style="cz9"/>(1) </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <table border="1" height="167" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3" height="36"> <span class="nag1">F. ADNOTACJE ORGANU</span> <br/> W przypadku informacji złożonej w postaci elektronicznej wypełnienie pól 123, 124 i 125 jest nieobowiązkowe. </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>123. Uwagi organu podatkowego<br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td height="49" width="472"> <b>124. Identyfikator przyjmującego formularz <br/> <br/> <br/> </b> <p/> </td> <td width="421"> <b>125. Podpis przyjmującego formularz </b> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:template match="*" mode="ObjasnieniaAkc"> <xsl:if test="ns1:* | opal:*"> <table width="955"> <tr> <td> <p align="center"> <b>Objaśnienia</b> </p> <br/> <p> <sup>1)</sup>Numer PESEL należy podać w przypadku składającego będącego osobą fizyczną objętą rejestrem PESEL nieprowadzącą działalności gospodarczej lub niebędącą zarejestrowanym podatnikiem podatku od towarów i usług.<br/> <sup>2)</sup>Dotyczy składających niebędących osobami fizycznymi.<br/> <sup>3)</sup>Dotyczy składających będących osobami fizycznymi.<br/> <sup>4)</sup>Datę powstania obowiązku zapłaty opłaty paliwowej wpisuje uprawniony odbiorca dokonujący nabycia wewnątrzwspólnotowego wyrobów akcyzowych poza procedurą zawieszenia poboru akcyzy w rozumieniu przepisów o podatku akcyzowym. <br/> <sup>5)</sup>Podstawę obliczenia wysokości opłaty paliwowej podaje się w tysiącach litrów albo tysiącach kilogramów, z dokładnością do trzech miejsc po przecinku. <br/> <sup>6)</sup>Kwoty opłaty paliwowej zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2022 r. poz. 2651, z późn. zm.).<br/> <sup>7)</sup>Należy wpisać numer referencyjny nadany przez system EMCS PL2 dla elektronicznego uproszczonego dokumentu administracyjnego (e-SAD). Kolumnę wypełnia się w przypadku nabycia wewnątrzwspólnotowego wyrobów akcyzowych wymienionych w załączniku nr 2 do ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2022 r. poz. 143, z późn. zm.), objętych stawką podatku akcyzowego inną niż stawka zerowa przez uprawnionego odbiorcę, z wyłączeniem nabycia wewnątrzwspólnotowego dokonywanego na podstawie dokumentu zastępującego e-SAD. <br/> <sup>8)</sup>Należy wpisać unikalny numer referencyjny zabezpieczenia akcyzowego nadawany w systemie OSOZ 2. Kolumnę wypełnia się w przypadku nabycia wewnątrzwspólnotowego przez uprawnionego odbiorcę wyrobów akcyzowych wymienionych w załączniku nr 2 do ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym, objętych stawką podatku akcyzowego inną niż stawka zerowa przez uprawnionego odbiorcę, z wyłączeniem nabycia wewnątrzwspólnotowego dokonywanego na podstawie dokumentu zastępującego e-SAD. </p> <p align="center"> <b>Pouczenie</b> </p> <br/> <p>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz. 19 lub wpłacenia jej w niepełnej wysokości, niniejsza informacja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2022 r. poz. 479, z późn. zm.).</p> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">OPAL</span> <sub style="cz9"/> (2) </td> </tr> </table> <table> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">PZOO</span> <sub style="cz9"/> (1) </td> </tr> </table> </xsl:if> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet>